/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.util.http;

import com.yourkit.asserts.NotNull;
import com.yourkit.asserts.Nullable;
import com.yourkit.util.FileUtil;
import com.yourkit.util.Strings;
import com.yourkit.util.http.HttpUri;
import com.yourkit.util.http.MediaType;
import com.yourkit.util.logging.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.Socket;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedTrustManager;

public final class HttpClient {
    @NotNull
    public static final String TRUST_ALL_SSL_CERTIFICATES = "yk.trustAllSslCertificates";
    @NotNull
    private HttpUri myUri;
    @NotNull
    private final HashMap<String, String> myRequestHeaders;
    private boolean myFollowRedirects;
    @Nullable
    private Method myMethod;
    private int myStatusCode;
    private int myContentLength;
    @NotNull
    private String myContentType;
    @NotNull
    private Map<String, List<String>> myResponseHeaders;
    @NotNull
    private String myContent;
    @NotNull
    private InvocationHandler myHandler;
    private boolean myTrustAllSslCertificates;
    private int myConnectTimeoutMs;
    private int myReadTimeoutMs;

    public HttpClient(@NotNull HttpUri uri) {
        if (uri == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        this.myRequestHeaders = new HashMap();
        this.myFollowRedirects = true;
        this.myStatusCode = -1;
        this.myContentLength = -1;
        this.myContentType = "";
        this.myResponseHeaders = Collections.emptyMap();
        this.myContent = "";
        this.myTrustAllSslCertificates = false;
        this.myConnectTimeoutMs = 0;
        this.myReadTimeoutMs = 0;
        this.myUri = uri;
        this.reset();
        this.myHandler = conn -> {
            String contentType = this.getContentType();
            if (contentType.contains(MediaType.APPLICATION_JSON.type) || contentType.contains(MediaType.APPLICATION_XML.type) || contentType.contains(MediaType.TEXT_HTML.type) || contentType.contains(MediaType.TEXT_PLAIN.type)) {
                Charset charset;
                InputStream in;
                try {
                    in = conn.getInputStream();
                }
                catch (IOException e) {
                    in = conn.getErrorStream();
                }
                if (in == null) {
                    return;
                }
                String _charsetName = this.getContentCharset();
                _charsetName = _charsetName != null ? _charsetName : Strings.UTF_8.name();
                try {
                    charset = Charset.forName(_charsetName);
                }
                catch (Throwable exc) {
                    Logger.error("Invalid charset='" + _charsetName + "'; contentType='" + this.getContentType() + "'", exc);
                    charset = StandardCharsets.UTF_8;
                }
                try {
                    StringBuilder _content = new StringBuilder(4096);
                    FileUtil.read(new InputStreamReader(in, charset), _content);
                    this.setContent(_content.toString());
                }
                finally {
                    in.close();
                }
            }
        };
        this.setUserAgent(System.getProperty("http.agent"));
        boolean trustAllSslCertificates = Boolean.getBoolean(TRUST_ALL_SSL_CERTIFICATES);
        this.setTrustAllSslCertificates(trustAllSslCertificates);
    }

    private void reset() {
        this.setStatusCode(-1);
        this.setContentLength(-1);
        this.setContentType("");
        this.resetResponseHeaders();
        this.setContent("");
    }

    @NotNull
    public HttpUri getUri() {
        HttpUri httpUri = this.myUri;
        if (httpUri == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return httpUri;
    }

    public void setUri(@NotNull HttpUri uri) {
        if (uri == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        this.myUri = uri;
    }

    @Nullable
    public String getUserAgent() {
        return this.getRequestHeader("User-Agent");
    }

    public void setUserAgent(@Nullable String userAgent) {
        this.setRequestHeader("User-Agent", userAgent);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private String getHeaderKey(@NotNull String key) {
        String string;
        if (key == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        for (String k : this.myRequestHeaders.keySet()) {
            if (!k.equalsIgnoreCase(key)) continue;
            string = k;
            if (string == null) throw new IllegalStateException("Method must not return null");
            return string;
        }
        string = key;
        if (string != null) return string;
        throw new IllegalStateException("Method must not return null");
    }

    @Nullable
    public String getRequestHeader(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        return this.myRequestHeaders.get(this.getHeaderKey(name));
    }

    @NotNull
    public HttpClient setRequestHeader(@NotNull String headerName, @Nullable String headerValue) {
        if (headerName == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        String _name = this.getHeaderKey(headerName);
        if (Strings.isNullOrEmpty(headerValue)) {
            this.myRequestHeaders.remove(_name);
        } else {
            this.myRequestHeaders.put(_name, headerValue);
        }
        HttpClient httpClient = this;
        if (httpClient == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return httpClient;
    }

    @NotNull
    public HttpClient setBearer(@Nullable String bearer) {
        HttpClient httpClient = this.setRequestHeader("authorization", bearer != null ? "Bearer " + bearer : null);
        if (httpClient == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return httpClient;
    }

    @NotNull
    public Map<? extends String, ? extends String> getRequestHeaders() {
        HashMap<String, String> hashMap = this.myRequestHeaders;
        if (hashMap == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return hashMap;
    }

    @NotNull
    public Map<String, List<String>> getResponseHeaders() {
        Map<String, List<String>> map = this.myResponseHeaders;
        if (map == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return map;
    }

    private void resetResponseHeaders() {
        this.myResponseHeaders = Collections.emptyMap();
    }

    public int getStatusCode() {
        return this.myStatusCode;
    }

    private void setStatusCode(int statusCode) {
        this.myStatusCode = statusCode;
    }

    public int getContentLength() {
        return this.myContentLength;
    }

    private void setContentLength(int contentLength) {
        this.myContentLength = contentLength;
    }

    @NotNull
    public String getContentType() {
        String string = this.myContentType;
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    private void setContentType(@NotNull String contentType) {
        if (contentType == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        this.myContentType = contentType;
    }

    @Nullable
    public String getContentCharset() {
        String contentType = this.getContentType();
        String charsetPrefix = "charset=";
        int idx = contentType.indexOf("charset=");
        return idx != -1 ? contentType.substring(idx + "charset=".length()) : null;
    }

    @NotNull
    public String getContent() {
        String string = this.myContent;
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    private void setContent(@NotNull String content) {
        if (content == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        this.myContent = content;
    }

    public boolean isFollowRedirects() {
        return this.myFollowRedirects;
    }

    public void setFollowRedirects(boolean followRedirects) {
        this.myFollowRedirects = followRedirects;
    }

    @NotNull
    public InvocationHandler getHandler() {
        InvocationHandler invocationHandler = this.myHandler;
        if (invocationHandler == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return invocationHandler;
    }

    public void setHandler(@NotNull InvocationHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        this.myHandler = handler;
    }

    public boolean isTrustAllSslCertificates() {
        return this.myTrustAllSslCertificates;
    }

    @NotNull
    public HttpClient setTrustAllSslCertificates(boolean trust) {
        this.myTrustAllSslCertificates = trust;
        HttpClient httpClient = this;
        if (httpClient == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return httpClient;
    }

    public int getConnectTimeoutMs() {
        return this.myConnectTimeoutMs;
    }

    public HttpClient setConnectTimeoutMs(int ms) {
        this.myConnectTimeoutMs = ms;
        return this;
    }

    public int getReadTimeoutMs() {
        return this.myReadTimeoutMs;
    }

    public HttpClient setReadTimeoutMs(int ms) {
        this.myReadTimeoutMs = ms;
        return this;
    }

    public HttpClient setTimeoutsMs(int ms) {
        return this.setConnectTimeoutMs(ms).setReadTimeoutMs(ms);
    }

    @Nullable
    public Method getMethod() {
        return this.myMethod;
    }

    private void setMethod(@Nullable Method method) {
        this.myMethod = method;
    }

    public HttpClient doGet() {
        this.setMethod(new Get());
        return this;
    }

    public HttpClient doPost() {
        this.setMethod(new Post());
        return this;
    }

    public HttpClient doJson(@NotNull String json) {
        if (json == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        this.setMethod(new PostBytes(MediaType.APPLICATION_JSON, json.getBytes(Strings.UTF_8)));
        return this;
    }

    public HttpClient doProtobuf(@NotNull byte[] payload) {
        if (payload == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        this.setMethod(new PostBytes(MediaType.APPLICATION_X_PROTOBUF, payload));
        return this;
    }

    public int invoke() throws IOException {
        if (this.myMethod == null) {
            throw new IllegalStateException("Request method is not set");
        }
        this.myMethod.invoke();
        return this.getStatusCode();
    }

    public static interface Body {
        @NotNull
        public MediaType getMediaType();

        @NotNull
        public byte[] getContent();
    }

    public static interface InvocationHandler {
        public void invoke(@NotNull HttpURLConnection var1) throws IOException;
    }

    private final class PostBytes
    extends Method {
        @NotNull
        private final MediaType myMediaType;
        @NotNull
        private final byte[] myPayload;

        public PostBytes(@NotNull MediaType mediaType, byte[] payload) {
            if (mediaType == null) {
                throw new IllegalArgumentException("Parameter 1 must not be null");
            }
            if (payload == null) {
                throw new IllegalArgumentException("Parameter 2 must not be null");
            }
            super("POST", true);
            this.myMediaType = mediaType;
            this.myPayload = payload;
        }

        @Override
        @NotNull
        protected Body getBody() {
            return new Body(){

                @Override
                @NotNull
                public MediaType getMediaType() {
                    MediaType mediaType = PostBytes.this.myMediaType;
                    if (mediaType == null) {
                        throw new IllegalStateException("Method must not return null");
                    }
                    return mediaType;
                }

                @Override
                @NotNull
                public byte[] getContent() {
                    byte[] byArray = PostBytes.this.myPayload;
                    if (byArray == null) {
                        throw new IllegalStateException("Method must not return null");
                    }
                    return byArray;
                }
            };
        }
    }

    private final class Post
    extends Method {
        public Post() {
            super("POST", false);
        }

        @Override
        @NotNull
        protected Body getBody() {
            return new Body(){

                @Override
                @NotNull
                public MediaType getMediaType() {
                    MediaType mediaType = MediaType.APPLICATION_X_WWW_FORM_URLENCODED;
                    if (mediaType == null) {
                        throw new IllegalStateException("Method must not return null");
                    }
                    return mediaType;
                }

                @Override
                @NotNull
                public byte[] getContent() {
                    String queryString = HttpClient.this.myUri.getUrlEncodedQuery();
                    byte[] byArray = queryString.getBytes(Strings.ASCII);
                    if (byArray == null) {
                        throw new IllegalStateException("Method must not return null");
                    }
                    return byArray;
                }
            };
        }
    }

    private final class Get
    extends Method {
        public Get() {
            super("GET", true);
        }

        @Override
        @Nullable
        protected Body getBody() {
            return null;
        }
    }

    private abstract class Method {
        @NotNull
        public final String myMethod;
        public final boolean myWithUrlEncodedQuery;

        public Method(String method, boolean withUrlEncodedQuery) {
            if (method == null) {
                throw new IllegalArgumentException("Parameter 1 must not be null");
            }
            this.myMethod = method;
            this.myWithUrlEncodedQuery = withUrlEncodedQuery;
        }

        @Nullable
        protected abstract Body getBody();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void invoke() throws IOException {
            HttpClient.this.reset();
            String urlAndQuery = HttpClient.this.myUri.newStringifier().withQuery(this.myWithUrlEncodedQuery).toString();
            URL url = new URL(urlAndQuery);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setUseCaches(false);
            conn.setInstanceFollowRedirects(HttpClient.this.myFollowRedirects);
            conn.setRequestMethod(this.myMethod);
            conn.setConnectTimeout(HttpClient.this.myConnectTimeoutMs);
            conn.setReadTimeout(HttpClient.this.myReadTimeoutMs);
            if (conn instanceof HttpsURLConnection && HttpClient.this.isTrustAllSslCertificates()) {
                HttpsURLConnection httpsConn = (HttpsURLConnection)conn;
                httpsConn.setSSLSocketFactory(this.createTrustAllSslCertificatedSocketFactory());
            }
            for (Map.Entry entry : HttpClient.this.myRequestHeaders.entrySet()) {
                String value = (String)entry.getValue();
                if (Strings.isNullOrEmpty(value)) continue;
                conn.setRequestProperty((String)entry.getKey(), value);
            }
            Body body = this.getBody();
            if (body != null) {
                conn.setDoOutput(true);
                conn.setRequestProperty("Content-Type", body.getMediaType().getContentTypeAndEncoding());
                byte[] byArray = body.getContent();
                conn.setRequestProperty("Content-Length", Integer.toString(byArray.length));
                try (OutputStream out = conn.getOutputStream();){
                    out.write(byArray);
                    out.flush();
                }
            }
            try {
                HttpClient.this.setStatusCode(conn.getResponseCode());
                HttpClient.this.setContentLength(conn.getContentLength());
                HttpClient.this.setContentType(Strings.notNull(conn.getContentType()));
                HttpClient.this.myResponseHeaders = conn.getHeaderFields();
                HttpClient.this.myHandler.invoke(conn);
            }
            finally {
                conn.disconnect();
            }
        }

        @NotNull
        private SSLSocketFactory createTrustAllSslCertificatedSocketFactory() {
            SSLSocketFactory sSLSocketFactory;
            TrustManager[] bypassTrustManagers = new TrustManager[]{new X509ExtendedTrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) {
                }

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) {
                }

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine engine) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine engine) {
                }
            }};
            try {
                SSLContext sc = SSLContext.getInstance("TLS");
                sc.init(null, bypassTrustManagers, new SecureRandom());
                sSLSocketFactory = sc.getSocketFactory();
            }
            catch (GeneralSecurityException exc) {
                throw new RuntimeException();
            }
            if (sSLSocketFactory == null) {
                throw new IllegalStateException("Method must not return null");
            }
            return sSLSocketFactory;
        }
    }
}

