/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.util.gson;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.yourkit.TimeConstants;
import com.yourkit.asserts.NotNull;
import com.yourkit.asserts.Nullable;
import com.yourkit.util.DeserializeException;
import com.yourkit.util.Strings;
import java.io.IOException;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Locale;

public final class InstantTypeAdapter
extends TypeAdapter<Instant> {
    @NotNull
    public static final DateTimeFormatter ISO_8601_UTC = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss[.SSS]X", Locale.US).withZone(TimeConstants.UTC_ZONE);
    @NotNull
    public static final DateTimeFormatter yyyy_MM_dd_time_zone = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss Z").withZone(TimeConstants.DEFAULT_ZONE);
    @NotNull
    private EpochPolicy myEpochPolicy = EpochPolicy.EPOCH_AS_NULL;

    @NotNull
    public InstantTypeAdapter setEpochPolicy(@NotNull EpochPolicy policy) {
        if (policy == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        this.myEpochPolicy = policy;
        InstantTypeAdapter instantTypeAdapter = this;
        if (instantTypeAdapter == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return instantTypeAdapter;
    }

    @Override
    public void write(@NotNull JsonWriter out, @Nullable Instant value) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (value != null) {
            if (this.myEpochPolicy == EpochPolicy.EPOCH_AS_NULL && value.equals(Instant.EPOCH)) {
                boolean serializeNulls = out.getSerializeNulls();
                out.setSerializeNulls(true);
                out.nullValue();
                out.setSerializeNulls(serializeNulls);
            } else {
                out.value(InstantTypeAdapter.serialize(value));
            }
        } else {
            out.nullValue();
        }
    }

    @Override
    public Instant read(@NotNull JsonReader in) throws IOException {
        if (in == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        JsonToken t = in.peek();
        if (t == JsonToken.NULL) {
            in.nextNull();
            return this.myEpochPolicy == EpochPolicy.EPOCH_AS_NULL ? Instant.EPOCH : null;
        }
        String str = in.nextString();
        if (str.isEmpty()) {
            throw new DeserializeException("Cannot read j.t.Instant from empty string");
        }
        return InstantTypeAdapter.deserialize(str);
    }

    @NotNull
    public static String serialize(@NotNull Instant i) {
        if (i == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        String string = ISO_8601_UTC.format(i);
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static Instant deserialize(@NotNull String str) throws DeserializeException {
        Instant instant;
        if (str == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (str.charAt(str.length() - 1) == 'Z') {
            instant = ISO_8601_UTC.parse((CharSequence)str, ZonedDateTime::from).toInstant();
            if (instant == null) throw new IllegalStateException("Method must not return null");
            return instant;
        }
        if (str.charAt(0) == '!') {
            Instant instant2;
            String formatted = str.substring(1);
            try {
                instant2 = yyyy_MM_dd_time_zone.parse((CharSequence)formatted, ZonedDateTime::from).toInstant();
            }
            catch (DateTimeParseException exc) {
                throw new DeserializeException("Invalid date format: " + str);
            }
            instant = instant2;
            if (instant2 == null) throw new IllegalStateException("Method must not return null");
            return instant;
        }
        int idx = str.indexOf(32);
        String msStr = idx != -1 ? str.substring(0, idx) : str;
        long ms = Strings.parseLong(msStr, -1L);
        if (ms < 0L) {
            throw new DeserializeException("Invalid date format: " + str);
        }
        instant = Instant.ofEpochMilli(ms);
        if (instant != null) return instant;
        throw new IllegalStateException("Method must not return null");
    }

    public static enum EpochPolicy {
        EPOCH_AS_IS,
        EPOCH_AS_NULL;

    }
}

