/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.util;

import com.yourkit.asserts.NotNull;
import com.yourkit.asserts.Nullable;
import com.yourkit.util.Properties;

public enum Os {
    AIX("AIX"),
    FREEBSD("FreeBSD"),
    HPUX("HP-UX"),
    LINUX("Linux"),
    MAC("macOS"),
    SOLARIS("Solaris"),
    UNKNOWN("Unknown"),
    WINDOWS("Windows");

    @NotNull
    private final String myName;
    @Nullable
    private static Os ourCurrent;

    private Os(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        this.myName = name;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static Os fromName(@NotNull String name) {
        Os os;
        if (name == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        for (Os os2 : Os.values()) {
            if (!os2.myName.equals(name)) continue;
            os = os2;
            if (os == null) throw new IllegalStateException("Method must not return null");
            return os;
        }
        os = UNKNOWN;
        if (os != null) return os;
        throw new IllegalStateException("Method must not return null");
    }

    public boolean isLinux() {
        return this == LINUX;
    }

    public boolean isMac() {
        return this == MAC;
    }

    public boolean isUnknown() {
        return this == UNKNOWN;
    }

    public boolean isWindows() {
        return this == WINDOWS;
    }

    @NotNull
    public static Os getCurrent() {
        if (ourCurrent == null) {
            ourCurrent = Os.getOsImpl();
        }
        Os os = ourCurrent;
        if (os == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return os;
    }

    public static void setCurrent(@Nullable Os os) {
        ourCurrent = os;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static Os getOsImpl() {
        Os os;
        String name = Properties.os_name.value("").toLowerCase();
        if (name.startsWith("linux")) {
            os = LINUX;
            if (os == null) throw new IllegalStateException("Method must not return null");
            return os;
        }
        if (name.startsWith("mac os x")) {
            os = MAC;
            if (os == null) throw new IllegalStateException("Method must not return null");
            return os;
        }
        if (name.startsWith("windows")) {
            os = WINDOWS;
            if (os == null) throw new IllegalStateException("Method must not return null");
            return os;
        }
        os = UNKNOWN;
        if (os != null) return os;
        throw new IllegalStateException("Method must not return null");
    }
}

