/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.controller;

import com.yourkit.asserts.NotNull;
import com.yourkit.asserts.Nullable;
import com.yourkit.util.Stopwatch;
import com.yourkit.util.Util;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;

public class SelfProfilingUtil {
    @NotNull
    public static InetSocketAddress getAgentAddress(int timeoutMs) {
        Stopwatch w = new Stopwatch();
        while (w.ms() < (long)timeoutMs) {
            InetSocketAddress address = SelfProfilingUtil.getAgentAddressFromCoreReflectImpl();
            if (address != null) {
                InetSocketAddress inetSocketAddress = address;
                if (inetSocketAddress == null) {
                    throw new IllegalStateException("Method must not return null");
                }
                return inetSocketAddress;
            }
            Util.sleep(50L);
        }
        throw new IllegalStateException("To profile application, you should run it with the profiler agent");
    }

    @Nullable
    private static InetSocketAddress getAgentAddressFromCoreReflectImpl() {
        try {
            ClassLoader loader = ClassLoader.getSystemClassLoader();
            Class<?> aClass = loader.loadClass("com.yourkit.runtime.Core");
            Field field = aClass.getDeclaredField("ourAgentAddress");
            return (InetSocketAddress)field.get(null);
        }
        catch (Throwable throwable) {
            return null;
        }
    }
}

