/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit;

import com.yourkit.asserts.NotNull;
import com.yourkit.asserts.Nullable;
import java.time.Instant;
import java.time.ZoneId;

public interface TimeConstants {
    @NotNull
    public static final ZoneId DEFAULT_ZONE = ZoneId.systemDefault();
    @NotNull
    public static final ZoneId UTC_ZONE = ZoneId.of("Z");
    @NotNull
    public static final Instant UNDEFINED_DATE = Instant.EPOCH;
    public static final long NANOS_PER_SEC = 1000000000L;
    public static final long NANOS_PER_MILLISECOND = 1000000L;
    public static final long NANOS_PER_MICROSECOND = 1000L;
    public static final long MKS_PER_MS = 1000L;
    public static final long MS_PER_DS = 100L;

    public static boolean isDefined(@Nullable Instant instant) {
        return instant != null && !instant.equals(UNDEFINED_DATE);
    }

    public static boolean isUndefined(@Nullable Instant i) {
        return !TimeConstants.isDefined(i);
    }

    public static boolean isBefore(@NotNull Instant i1, @NotNull Instant i2) {
        if (i1 == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (i2 == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        return TimeConstants.isDefined(i1) && TimeConstants.isDefined(i2) && i1.isBefore(i2);
    }

    public static boolean isAfter(@NotNull Instant i1, @NotNull Instant i2) {
        if (i1 == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (i2 == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        return TimeConstants.isDefined(i1) && TimeConstants.isDefined(i2) && i1.isAfter(i2);
    }

    public static long msToNs(long ms) {
        return ms * 1000000L;
    }

    public static long nsToMs(long ns) {
        return ns / 1000000L;
    }

    @NotNull
    public static Instant nullToUndefined(@Nullable Instant i) {
        Instant instant = i == null ? UNDEFINED_DATE : i;
        if (instant == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return instant;
    }

    @Nullable
    public static Instant undefinedToNull(@Nullable Instant i) {
        return TimeConstants.isUndefined(i) ? null : i;
    }
}

